/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.signals.watch.common.HttpClient;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import com.floragunn.signals.watch.common.TlsConfig;
import com.floragunn.signals.watch.common.WatchElement;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class HttpClientConfig
extends WatchElement {
    private final Integer connectionTimeoutSecs;
    private final Integer readTimeoutSecs;
    private final TlsConfig tlsConfig;
    private final HttpProxyConfig proxyConfig;

    public HttpClientConfig(Integer connectionTimeoutSecs, Integer readTimeoutSecs, TlsConfig tlsConfig, HttpProxyConfig proxyConfig) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
        this.readTimeoutSecs = readTimeoutSecs;
        this.tlsConfig = tlsConfig;
        this.proxyConfig = proxyConfig;
    }

    public HttpClient createHttpClient(HttpProxyConfig defaultProxyConfig) {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        if (this.connectionTimeoutSecs != null) {
            configBuilder.setConnectTimeout(this.connectionTimeoutSecs * 1000);
            configBuilder.setConnectionRequestTimeout(this.connectionTimeoutSecs * 1000);
        } else {
            configBuilder.setConnectTimeout(10000);
            configBuilder.setConnectionRequestTimeout(10000);
        }
        if (this.readTimeoutSecs != null) {
            configBuilder.setSocketTimeout(this.readTimeoutSecs * 1000);
        } else {
            configBuilder.setSocketTimeout(10000);
        }
        RequestConfig config = configBuilder.build();
        HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultRequestConfig(config);
        clientBuilder.useSystemProperties();
        clientBuilder.setDefaultCredentialsProvider(null);
        if (this.tlsConfig != null) {
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.tlsConfig.toSSLConnectionSocketFactory());
        }
        HttpHost proxy = null;
        if (defaultProxyConfig != null) {
            proxy = defaultProxyConfig.getProxy();
        }
        if (this.proxyConfig != null) {
            if (this.proxyConfig.getType() == HttpProxyConfig.Type.USE_SPECIFIC_PROXY) {
                proxy = this.proxyConfig.getProxy();
            } else if (this.proxyConfig.getType() == HttpProxyConfig.Type.USE_NO_PROXY) {
                proxy = null;
            }
        }
        if (proxy != null) {
            clientBuilder.setProxy(proxy);
        }
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            return AccessController.doPrivileged(() -> new HttpClient(clientBuilder.build()));
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.readTimeoutSecs != null) {
            builder.field("read_timeout", this.readTimeoutSecs);
        }
        if (this.connectionTimeoutSecs != null) {
            builder.field("connection_timeout", this.connectionTimeoutSecs);
        }
        if (this.tlsConfig != null) {
            builder.field("tls", (ToXContent)this.tlsConfig);
        }
        if (this.proxyConfig != null && this.proxyConfig.getType() != HttpProxyConfig.Type.USE_DEFAULT_PROXY) {
            builder.field("proxy");
            this.proxyConfig.toXContent(builder, params);
        }
        return builder;
    }

    public static HttpClientConfig create(ValidatingDocNode jsonObject) throws ConfigValidationException {
        Integer connectionTimeout = null;
        Integer readTimeout = null;
        TlsConfig tlsConfig = null;
        HttpProxyConfig proxyConfig = null;
        if (jsonObject.hasNonNull("read_timeout")) {
            readTimeout = jsonObject.get("read_timeout").asInteger();
        }
        if (jsonObject.hasNonNull("connection_timeout")) {
            connectionTimeout = jsonObject.get("connection_timeout").asInteger();
        }
        tlsConfig = (TlsConfig)jsonObject.get("tls").by(TlsConfig::create);
        proxyConfig = (HttpProxyConfig)jsonObject.get("proxy").byString(HttpProxyConfig::create);
        return new HttpClientConfig(connectionTimeout, readTimeout, tlsConfig, proxyConfig);
    }

    public boolean isNull() {
        return this.connectionTimeoutSecs == null && this.readTimeoutSecs == null && this.tlsConfig == null && this.proxyConfig == null;
    }

    public HttpProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }
}

